<?php

namespace App\Http\Controllers\SuperAdmin;

use App\Exports\SuperAdmin\TherapistEducationsExport;
use App\Http\Controllers\Controller;
use App\Http\Requests\SuperAdmin\TherapistCommunityCertifications\CreateRequest;
use App\Http\Requests\ImportRequest;
use App\Imports\SuperAdmin\TherapistCommunityEducationsImport;
use App\Models\Certification;
use App\Models\TherapistCommunity;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;

class TherapistCommunityCertificationsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    /********* Initialize Permission based Middlewares  ***********/
    public function __construct()
    {
        $this->middleware('permission:therapist_community.add_certification');
        $this->middleware('permission:therapist_community.add_certification', ['only' => ['store']]);
        $this->middleware('permission:therapist_community.add_certification', ['only' => ['update']]);
        $this->middleware('permission:therapist_community.add_certification', ['only' => ['destroy']]);
        $this->middleware('permission:therapist_community.add_certification', ['only' => ['export']]);
        $this->middleware('permission:therapist_community.add_certification', ['only' => ['import']]);
    }
    /********* Getter For Pagination, Searching And Sorting  ***********/
    public function getter($req = null, $export = null, $therapist_community)
    {
        if ($req != null) {
            $therapist_community_certifications =  $therapist_community->therapist_community_certifications();
            if ($req->trash && $req->trash == 'with') {
                $therapist_community_certifications =  $therapist_community_certifications->withTrashed();
            }
            if ($req->trash && $req->trash == 'only') {
                $therapist_community_certifications =  $therapist_community_certifications->onlyTrashed();
            }
            if ($req->column && $req->column != null && $req->search != null) {
                $therapist_community_certifications = $therapist_community_certifications->whereLike($req->column, $req->search);
            } else if ($req->search && $req->search != null) {

                $therapist_community_certifications = $therapist_community_certifications->whereLike(['name', 'description'], $req->search);
            }
            if ($req->sort_field != null && $req->sort_type != null) {
                $therapist_community_certifications = $therapist_community_certifications->OrderBy($req->sort_field, $req->sort_type);
            } else {
                $therapist_community_certifications = $therapist_community_certifications->OrderBy('id', 'desc');
            }
            if ($export != null) { // for export do not paginate
                $therapist_community_certifications = $therapist_community_certifications->get();
                return $therapist_community_certifications;
            }
            $therapist_community_certifications = $therapist_community_certifications->get();
            return $therapist_community_certifications;
        }
        $therapist_community_certifications = $therapist_community->therapist_community_certifications()->withAll()->orderBy('id', 'desc')->get();
        return $therapist_community_certifications;
    }


    /*********View All TherapistCommunityCertifications  ***********/
    public function index(Request $request, TherapistCommunity $therapist_community)
    {
        $therapist_community_certifications = $this->getter($request, null, $therapist_community);
        return view('super_admins.therapist_communitys.therapist_community_certifications.index', compact('therapist_community_certifications', 'therapist_community'));
    }

    /*********View Create Form of Certification  ***********/
    public function create(TherapistCommunity $therapist_community)
    {
        return view('super_admins.therapist_communitys.therapist_community_certifications.create', compact('therapist_community'));
    }

    /*********Store Certification  ***********/
    public function store(CreateRequest $request, TherapistCommunity $therapist_community)
    {
        $data = $request->all();
        try {
            DB::beginTransaction();
            if (!$request->is_active) {
                $data['is_active'] = 0;
            }
            $data = $request->all();
            $data['image'] = uploadFile($request, 'file', 'therapist_community_certifications');
            $therapist_community_certification = $therapist_community->therapist_community_certifications()->create($data);
            $therapist_community_certification = $therapist_community->therapist_community_certifications()->withAll()->find($therapist_community_certification->id);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            return redirect()->route('super_admin.therapist_community_certifications.index', $therapist_community->id)->with('message', 'Something Went Wrong')->with('message_type', 'error');
        }
        return redirect()->route('super_admin.therapist_community_certifications.index', $therapist_community->id)->with('message', 'Certificate Created Successfully')->with('message_type', 'success');
    }

    /*********View Certification  ***********/
    public function show(TherapistCommunity $therapist_community, Certification $therapist_community_certification)
    {
        if ($therapist_community->id != $therapist_community_certification->therapist_community_id) {
            return redirect()->back()->with('message', 'Certification Not Found')->with('message_type', 'error');
        }
        return view('super_admins.therapist_communitys.therapist_community_certifications.show', compact('therapist_community_certification', 'therapist_community'));
    }

    /*********View Edit Form of Certification  ***********/
    public function edit(TherapistCommunity $therapist_community, Certification $therapist_community_certification)
    {
        if ($therapist_community->id != $therapist_community_certification->therapist_community_id) {
            return redirect()->back()->with('message', 'Certification Not Found')->with('message_type', 'error');
        }
        return view('super_admins.therapist_communitys.therapist_community_certifications.edit', compact('therapist_community_certification', 'therapist_community'));
    }

    /*********Update Certification  ***********/
    public function update(CreateRequest $request, TherapistCommunity $therapist_community, Certification $therapist_community_certification)
    {
        if ($therapist_community->id != $therapist_community_certification->therapist_community_id) {
            return redirect()->back()->with('message', 'Certification Not Found')->with('message_type', 'error');
        }
        $data = $request->all();
        try {
            DB::beginTransaction();
            if (!$request->is_active) {
                $data['is_active'] = 0;
            }
            $data = $request->all();
            if ($request->file) {
                $data['image'] = uploadFile($request, 'file', 'therapist_community_certifications', $therapist_community_certification->image);
            } else {
                $data['image'] = $therapist_community_certification->image;
            }
            $therapist_community_certification->update($data);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            return redirect()->route('super_admin.therapist_community_certifications.index', $therapist_community->id)->with('message', 'Something Went Wrong')->with('message_type', 'error');
        }
        return redirect()->route('super_admin.therapist_community_certifications.index', $therapist_community->id)->with('message', 'Certification Updated Successfully')->with('message_type', 'success');
    }

    /********* Export  CSV And Excel  **********/
    public function export(Request $request)
    {
        $therapist_community_certifications = $this->getter($request, "export");
        if (in_array($request->export, ['csv,xlsx'])) {
            $extension = $request->export;
        } else {
            $extension = 'xlsx';
        }
        $filename = "therapist_community_certifications." . $extension;
        return Excel::download(new TherapistEducationsExport($therapist_community_certifications), $filename);
    }
    /********* Import CSV And Excel  **********/
    public function import(ImportRequest $request)
    {
        $file = $request->file('file');
        Excel::import(new TherapistCommunityEducationsImport, $file);
        return redirect()->back()->with('message', 'Certification Categories imported Successfully')->with('message_type', 'success');
    }


    /*********Soft DELETE Certification ***********/
    public function destroy(TherapistCommunity $therapist_community, Certification $therapist_community_certification)
    {
        if ($therapist_community->id != $therapist_community_certification->therapist_community_id) {
            return redirect()->back()->with('message', 'Certification Not Found')->with('message_type', 'error');
        }
        $therapist_community_certification->delete();
        return redirect()->back()->with('message', 'Certification Deleted Successfully')->with('message_type', 'success');
    }

    /*********Permanently DELETE Certification ***********/
    public function destroyPermanently(Request $request, TherapistCommunity $therapist_community, $therapist_community_certification)
    {
        $therapist_community_certification = Certification::withTrashed()->find($therapist_community_certification);
        if ($therapist_community_certification) {
            if ($therapist_community_certification->trashed()) {
                if ($therapist_community_certification->image && file_exists(public_path($therapist_community_certification->image))) {
                    unlink(public_path($therapist_community_certification->image));
                }
                $therapist_community_certification->forceDelete();
                return redirect()->back()->with('message', 'Certification Deleted Successfully')->with('message_type', 'success');
            } else {
                return redirect()->back()->with('message', 'Certification is Not in Trash')->with('message_type', 'error');
            }
        } else {
            return redirect()->back()->with('message', 'Certification Not Found')->with('message_type', 'error');
        }
    }
    /********* Restore Certification***********/
    public function restore(Request $request, TherapistCommunity $therapist_community, $therapist_community_certification)
    {
        $therapist_community_certification = Certification::withTrashed()->find($therapist_community_certification);
        if ($therapist_community_certification->trashed()) {
            $therapist_community_certification->restore();
            return redirect()->back()->with('message', 'Certification Restored Successfully')->with('message_type', 'success');
        } else {
            return redirect()->back()->with('message', 'Certification Not Found')->with('message_type', 'error');
        }
    }
}
